raw_data1 = readmatrix('long1.txt');
raw_data2 = readmatrix('long2.txt');
raw_data3 = readmatrix('long3.txt');
raw_data4 = readmatrix('long4.txt');
raw_data5 = readmatrix('long5.txt');

wavelength = raw_data1(:,1);
signal_1 = (raw_data1(:,2) + raw_data2(:,2) + raw_data3(:,2) + raw_data4(:,2) + raw_data5(:,2))/5;

raw_data1 = readmatrix('short1.txt');
raw_data2 = readmatrix('short2.txt');
raw_data3 = readmatrix('short3.txt');
raw_data4 = readmatrix('short4.txt');
raw_data5 = readmatrix('short5.txt');

signal_2 = (raw_data1(:,2) + raw_data2(:,2) + raw_data3(:,2) + raw_data4(:,2) + raw_data5(:,2))/5;

hold on
plot(wavelength,signal_1,'LineWidth',1.5);
plot(wavelength,signal_2,'LineWidth',1.5);
xlabel('Wavelength / nm')
ylabel('Signal / dB')
xlim([350 1250])
ylim([-90 -55])
legend('49.9 m','8.9 m')
% title('Transmission')
set(gca,'XMinorTick','on','YMinorTick','on')
set(gca,'FontSize',25)
set(gcf,'color','w')
hold off

loss2 = (signal_2 - signal_1)/41;

% nexttile
% hold on
% box on
% plot(wavelength,loss2,'LineWidth',3)
% xlabel('Wavelength / nm')
% ylabel('Attenuation / dB per m')
% xlim([350 1100])
% ylim([0 1])
% legend('49.9m to 8.9m')
% % title('Attenuation')
% set(gca,'XMinorTick','on','YMinorTick','on')
% set(gca,'FontSize',20)
% set(gcf,'color','w')
% hold off


%%

nexttile
hold on
box on
plot(wavelength,loss2,'LineWidth',1.5,'Color',[0.4940 0.1840 0.5560])
xlabel('Wavelength / nm')
ylabel('Attenuation / dB per m')
xlim([425 1000])
ylim([0 1])
% legend('47.7 m to 8.9 m')
% title('Attenuation')
set(gca,'XMinorTick','on','YMinorTick','on')
set(gca,'XMinorTick','on','YMinorTick','on')
set(gca,'FontSize',24)
set(gcf,'color','w')
xticks(400:100:1000)
set(gcf,'position',[x0,y0,width,height])
H=gca;
H.LineWidth=2;

x = [590 690 690 590];
y = [0 0 1 1];
patch(x,y,'black','FaceAlpha',.3,'EdgeAlpha',.5)

x2 = [975 1050 1050 975];
y2 = [0 0 1 1];
patch(x2,y2,'black','FaceAlpha',.3,'EdgeAlpha',.5)
hold off

% 
% 
% txt2 = '(c)';
% t2 = text(500,0.875,txt2,'FontSize',28);
% hold on


